//
//  MCReportGenerator.h
//  Composer
//
//  Created by Alykhan Jetha on 23/06/05.
//  Copyright 2005 Marketcircle Inc.. All rights reserved.
//

#import <Cocoa/Cocoa.h>

@class MCReportRenderCanvas;
@class MCReportLayout;
@class MCPDatabaseObjectContext;
@class MCReportWrapper;
@class MCFormatterManager;

typedef enum _MCRRenderOutputStyle {
    MCRRenderPreviewAppJob = 0,
    MCRRenderSaveToFileJob,
    MCRRenderInMemoryJob,
	MCRRenderPreviewInMemoryJob,
} MCRRenderOutputStyle;

typedef enum _MCRenderOperatingMode {
    MCRStandardOperatingMode = 0,
	MCRPreviewOperatingMode,
} MCRenderOperatingMode;


@interface MCReportGenerator : NSObject {
	NSMutableArray *layoutQueue;
	
	MCPDatabaseObjectContext *objectContext;
	
	MCReportLayout *workingLayout;
	
	MCReportRenderCanvas *lastRenderCanvas;
	MCRRenderOutputStyle renderStyle;
	MCRenderOperatingMode operatingMode;
	
	NSDocument *document;
	NSArray *objects;
	NSPrintInfo *printInfo;
	NSDictionary *reportInfo;
	MCReportLayout *reportLayout;
	NSDictionary *arguments;
	
	NSFileWrapper *fileWrapper;
	
	MCFormatterManager *formatterManager;
	
	id delegate;
	
	BOOL abort;
	NSRect bodyFrame;
	
}


+ (BOOL)isBehaviorHandledAsToMany:(NSString *)behavoir;


+ (MCReportGenerator *)reportGeneratorForReportLayout:(MCReportLayout *)aLayout 
										   reportInfo:(NSDictionary *)aInfo 
											printInfo:(NSPrintInfo *)aPrintInfo 
										objectContext:(MCPDatabaseObjectContext *)aContext 
											  objects:(NSArray *)objects 
											arguments:(NSDictionary *)args;


/*
 Document must respond to the following keys (valueForKey:)
     - objectContext (MCPDatabaseObjectContext)
     - currentUser (can be nil)
     - databaseUserDefaults (MCUserDefaults)
 */
+ (MCReportGenerator *)reportGeneratorForReportLayout:(MCReportLayout *)aLayout 
										   reportInfo:(NSDictionary *)aInfo 
											printInfo:(NSPrintInfo *)aPrintInfo 
											 document:(NSDocument *)aDocument 
											  objects:(NSArray *)objects 
											arguments:(NSDictionary *)args;

+ (MCReportGenerator *)reportGeneratorForReportWrapper:(MCReportWrapper *)aWrapper 
											  document:(NSDocument *)aDocument 
											   objects:(NSArray *)objects 
											 arguments:(NSDictionary *)args;

/*
 Fetches simulation data if appropriate, then calls the regular generation method(s)
 */
- (BOOL)generateSimulationReport;
- (BOOL)generateReport;

- (void)setDelegate:(id)aDeleg;
- (id)delegate;

- (MCReportRenderCanvas *)renderedView;

- (BOOL)deliverResultsToPreviewApp;
- (BOOL)deliverResultsToFile:(NSString *)aPath;

- (MCRRenderOutputStyle)renderStyle;
- (void)setRenderStyle:(MCRRenderOutputStyle)aRenderStyle;

/*!
 Setup the operating mode so that custom scripts can know when in preview or in standard mode - in the event that something different has to be done in preview.
 */
- (MCRenderOperatingMode)operatingMode;
- (void)setOperatingMode:(MCRenderOperatingMode)aOpMode;
- (BOOL)inStandardMode;
- (BOOL)inPreviewMode;

- (MCPDatabaseObjectContext *)objectContext;
- (void)setObjectContext:(MCPDatabaseObjectContext *)anObjectContext;

- (MCReportLayout *)workingLayout;
- (void)setWorkingLayout:(MCReportLayout *)aWorkingLayout;

- (NSDocument *)document;
- (void)setDocument:(NSDocument *)aDocument;

- (NSArray *)objects;
- (void)setObjects:(NSArray *)anObjects;

// creates a formatterManager if one has not been created before
- (MCFormatterManager *)formatterManager;

- (NSPrintInfo *)printInfo;
- (void)setPrintInfo:(NSPrintInfo *)aPrintInfo;

- (NSDictionary *)reportInfo;
- (void)setReportInfo:(NSDictionary *)aReportInfo;

- (MCReportLayout *)reportLayout;
- (void)setReportLayout:(MCReportLayout *)aReportLayout;

- (NSDictionary *)arguments;
- (void)setArguments:(NSDictionary *)anArguments;

- (NSFileWrapper *)fileWrapper;
- (void)setFileWrapper:(NSFileWrapper *)aFileWrapper;

// If you want to abruptly end the generation, call this.
- (void)abort;

// Useful when slicing super fat rows outside the view hierarchy
- (NSRect)bodyFrame;

/**
 * Convenience method
 */

- (NSString *)formatterManagerTimeZoneID;

@end

@interface NSObject (MCReportGeneratorDelegate)
- (void)reportGeneratorWillGenerateReport:(MCReportGenerator *)aGen;
- (void)reportGeneratorDidAddPage:(MCReportGenerator *)aGen;
- (BOOL)reportGeneratorShouldAddPage:(MCReportGenerator *)aGen;
@end

